require( "scripts/style.lua" );

SliderFont = {
  standardFont,
  24,
  BlackColor
};


MakeDialog
{
	Bitmap
	{
		name="pausebackground",
		image="backgrounds/dialog",
		x = kCenter,
		y = kCenter,
		
		OptionsWindow
		{
			x=0,y=0,w=kMax,h=kMax,
			
			
			Text
			{
				font = SliderFont,
				name = "sfx",
				x=220,y=175,w=50,h=50,
				flags = kHAlignCenter + kVAlignCenter,
				label = "sfxlevel"
			};
		
			Slider
			{
				name="sfxlevelslider",
				railimage = "buttons/sliderrail.png",
				sliderimage = "buttons/sliderknob.png",
				sliderrollimage = "buttons/sliderknobover.png",
				x = 290,
				y = 170,
			};
			
			Text
			{
				font = SliderFont,
				name = "music",
				x=220,y=245,w=50,h=50,
				flags = kHAlignCenter + kVAlignCenter,
				label = "musiclevel"
			};
			
			Slider
			{
				name="musiclevelslider",
				railimage = "buttons/sliderrail.png",
				sliderimage = "buttons/sliderknob.png",
				sliderrollimage = "buttons/sliderknobover.png",
				x = 290,
				y = 240,
			};
			
			
			
			Button{
				graphics = CheckboxButtonGraphics,
				name="fullscreen",
				type = kToggle,
				x=250,
				y=310,
				w=150,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command=
				function()
					if (ToggleFullScreen() == false) then
						DisplayDialog { 
							"scripts/ok.lua", 
							body ="screenswitchfailed",
							title = "game.title" 
						};
					end
				end
				
			};
			
			Text
			{
				font = StandardButtonFont,
				name = "fullscreenlabel",
				x=300,
				y=320,
				w=200,
				h=50,
				flags = kHAlignLeft + kVAlignTop,
				label="fullscreen",
			};

			Button{
				graphics = CheckboxButtonGraphics,
				name="mutebox",
				type = kToggle,
				x=425,
				y=310,
				w=175,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command =
					function()
						ToggleSoundMute();
					end
			};

			Text
			{
				font = StandardButtonFont,
				name = "mutesoundlabel",
				x=475,
				y=320,
				w=50,
				h=50,
				flags = kHAlignLeft + kVAlignTop,
				label="mutesound",
			};

			Button
			{
				x=260,
				y=370,
				font = StandardButtonFont,
				graphics = StandardButtonGraphics,
				name="back",
				label="ok",
				type = kPush,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command =
					function()
						SaveVolumes();
						PopModal();
					end
			},
			
			Button
			{
				x=425,
				y=370,
				font = StandardButtonFont,
				graphics = StandardButtonGraphics,
				name="credits",
				label="credits",
				type = kPush,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command =
					function()
						DoModal("scripts/credits.lua");
					end
			},
		},
	},
}